/*
 * Decompiled with CFR 0.152.
 */
package com.nyfaria.numismaticoverhaul.owostuff.ui.core;

import com.google.common.collect.ImmutableMap;
import com.nyfaria.numismaticoverhaul.owostuff.ui.core.Animatable;
import com.nyfaria.numismaticoverhaul.owostuff.ui.parsing.UIModelParsingException;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.util.Mth;
import net.minecraft.world.item.DyeColor;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Node;

public record Color(float red, float green, float blue, float alpha) implements Animatable<Color>
{
    public static final Color BLACK = Color.ofRgb(0);
    public static final Color WHITE = Color.ofRgb(0xFFFFFF);
    public static final Color RED = Color.ofRgb(0xFF0000);
    public static final Color GREEN = Color.ofRgb(65280);
    public static final Color BLUE = Color.ofRgb(255);
    private static final Map<String, Color> NAMED_TEXT_COLORS = (Map)Stream.of(ChatFormatting.values()).filter(ChatFormatting::m_126664_).collect(ImmutableMap.toImmutableMap(formatting -> formatting.m_126666_().toLowerCase(Locale.ROOT).replace("_", "-"), Color::ofFormatting));

    public Color(float red, float green, float blue) {
        this(red, green, blue, 1.0f);
    }

    public static Color ofArgb(int argb) {
        return new Color((float)(argb >> 16 & 0xFF) / 255.0f, (float)(argb >> 8 & 0xFF) / 255.0f, (float)(argb & 0xFF) / 255.0f, (float)(argb >>> 24) / 255.0f);
    }

    public static Color ofRgb(int rgb) {
        return new Color((float)(rgb >> 16 & 0xFF) / 255.0f, (float)(rgb >> 8 & 0xFF) / 255.0f, (float)(rgb & 0xFF) / 255.0f, 1.0f);
    }

    public static Color ofHsv(float hue, float saturation, float value) {
        return Color.ofRgb(Mth.m_14169_((float)hue, (float)saturation, (float)value));
    }

    public static Color ofFormatting(@NotNull ChatFormatting formatting) {
        Integer colorValue = formatting.m_126665_();
        return Color.ofRgb(colorValue == null ? 0 : colorValue);
    }

    public static Color ofDye(@NotNull DyeColor dyeColor) {
        float[] components = dyeColor.m_41068_();
        return new Color(components[0], components[1], components[2]);
    }

    public int rgb() {
        return (int)(this.red * 255.0f) << 16 | (int)(this.green * 255.0f) << 8 | (int)(this.blue * 255.0f);
    }

    public int argb() {
        return (int)(this.alpha * 255.0f) << 24 | (int)(this.red * 255.0f) << 16 | (int)(this.green * 255.0f) << 8 | (int)(this.blue * 255.0f);
    }

    @Override
    public Color interpolate(Color next, float delta) {
        return new Color(Mth.m_14179_((float)delta, (float)this.red, (float)next.red), Mth.m_14179_((float)delta, (float)this.green, (float)next.green), Mth.m_14179_((float)delta, (float)this.blue, (float)next.blue), Mth.m_14179_((float)delta, (float)this.alpha, (float)next.alpha));
    }

    public static Color parse(Node node) {
        String text = node.getTextContent().strip();
        if (!text.startsWith("#")) {
            Color color = NAMED_TEXT_COLORS.get(text);
            if (color != null) {
                return color;
            }
            throw new UIModelParsingException("Invalid color value '" + text + "', expected hex color of format #RRGGBB or #AARRGGBB or named text color");
        }
        if (text.matches("#([A-Fa-f\\d]{2}){3,4}")) {
            return text.length() == 7 ? Color.ofRgb(Integer.parseUnsignedInt(text.substring(1), 16)) : Color.ofArgb(Integer.parseUnsignedInt(text.substring(1), 16));
        }
        throw new UIModelParsingException("Invalid color value '" + text + "', expected hex color of format #RRGGBB or #AARRGGBB or named text color");
    }

    public static int parseAndPack(Node node) {
        return Color.parse(node).argb();
    }
}

